The [$ERROR]($ERROR) metacommand triggers a compilation error.

## Syntax

>  [$ERROR]($ERROR) MESSAGE

## Description

* The Metacommand does **not** require a comment or REM before it.
* MESSAGE is any text. Quotation marks are not required.
* When QB64 tries to compile an $ERROR metacommand a compilation error is triggered and MESSAGE is shown to the user. This is useful in [$IF]($IF) blocks.

### Details

* If there is a particular situation where you know your program will not work properly, you can prevent the user compiling and give them a helpful error message instead by checking for the condition with [$IF]($IF).
* An [$ERROR]($ERROR) directive not inside an [$IF]($IF) (or [$ELSEIF]($ELSEIF)) block is useless because the program will never compile.

## Example(s)

```vb

$IF VERSION < 2.1 OR WINDOWS = 0 THEN
    $ERROR Requires Windows QB64 version 2.1 or above
$END IF

```

*Output*: Compilation check failed: REQUIRES WINDOWS QB64 VERSION 2.1 OR ABOVE on line 2 (assuming your version of QB64 doesn't meet those requirements).

## See Also

* [Metacommand](Metacommand)
* [$IF]($IF)
