[CLOSE](CLOSE) closes an open file or port using the number(s) assigned in an [OPEN](OPEN) statement.

## Syntax

> [CLOSE](CLOSE) [fileNumber[, ...]]

## Parameter(s)

* fileNumber indicates the file or list of file numbers to close. When not specified, all open files are closed.

## Description

* A file must be closed when changing to another file mode.
* [CLOSE](CLOSE) files when they are no longer needed, in order to save memory.
* Files cannot be opened in the same [OPEN](OPEN) mode using another number until the first one is closed.
* Use holding variables for each file number returned by [FREEFILE](FREEFILE) so that the file reference is known.
* Will not return an error if a filenumber is already closed or was never opened. It does not verify that a file was closed.
* [CLEAR](CLEAR) can be used to close all open files.
* [CLOSE](CLOSE) can also be used to close an open TCP/IP connection using a handle returned by **QB64**.

## See Also

* [OPEN](OPEN), [OPEN COM](OPEN-COM)
* [_OPENCLIENT](_OPENCLIENT), [_OPENHOST](_OPENHOST)
* [_OPENCONNECTION](_OPENCONNECTION)
* [_SNDCLOSE](_SNDCLOSE)
