The [CVD](CVD) function decodes an 8-byte [STRING](STRING) generated by [MKD$](MKD$) (or read from a file) to [DOUBLE](DOUBLE) numeric values.

## Syntax

> result# = [CVD](CVD)(stringData$)

## Description

* *CV* functions ([CVD](CVD), [CVS](CVS), [CVI](CVI), [CVL](CVL), [CVDMBF](CVDMBF), [CVSMBF](CVSMBF)) are used to convert values encoded by *MK$* functions ([MKD$](MKD$), [MKS$](MKS$), [MKI$](MKI$), [MKL$](MKL$), [MKDMBF$](MKDMBF$), [MKSMBF$](MKSMBF$)).
* Variables of numerical types are also encoded when [PUT](PUT) to a [RANDOM](RANDOM) or [BINARY](BINARY)-access file.
* **QB64** has [_CV](_CV) and [_MK$](_MK$) functions which can also deal with extended [Data types](Data-types).
* [DOUBLE](DOUBLE) values can range up to 15 decimal point digits. Decimal point accuracy depends on whole value places taken.

## Example(s)

Reading an 8-byte encoded string n$ from a file and obtaining the decoded [DOUBLE](DOUBLE) value:

```vb

FIELD #1, 8 AS N$, 12 AS B$...
GET #1
Y# = CVD(N$) 

```

>  *Explanation:* Reads a field from file #1, and converts the first eight bytes (N$) into an double-precision number assigned to the variable Y#.

Showcases the reduced space to store an encoded number.

```vb

a# = 77000.24523213
PRINT "Value of a#:"; a#
b$ = MKD$(a#)
PRINT "Value of a# encoded using MKD$: "; b$
PRINT "The string above, decoded using CVD:"; CVD(b$)

```

```text

Value of a#: 77000.24523213

Value of a# encoded using MKD$: ñåxýâ╠‗@

The string above, decoded using CVD: 77000.24523213

```

> Since the representation of a double-precision number can use up to 15 ASCII characters (fifteen bytes), writing to a file using [MKD$](MKD$) conversion, and then reading back with the [CVD](CVD) conversion can save up to 7 bytes of storage space.

## See Also

* [MKD$](MKD$), [MKI$](MKI$), [MKS$](MKS$), [MKL$](MKL$), [MKDMBF$](MKDMBF$), [MKSMBF$](MKSMBF$)
* [CVI](CVI), [CVS](CVS), [CVL](CVL), [CVSMBF](CVSMBF), [CVDMBF](CVDMBF)
* [_CV](_CV), [_MK$](_MK$)
