The [CVI](CVI) function decodes a 2-byte [STRING](STRING) generated by [MKI$](MKI$) (or read from a file) to [INTEGER](INTEGER) numeric values.

## Syntax

> result% = [CVI](CVI)(stringData$)

## Description

* *CV* functions ([CVD](CVD), [CVS](CVS), [CVI](CVI), [CVL](CVL), [CVDMBF](CVDMBF), [CVSMBF](CVSMBF)) are used to convert values encoded by *MK$* functions ([MKD$](MKD$), [MKS$](MKS$), [MKI$](MKI$), [MKL$](MKL$), [MKDMBF$](MKDMBF$), [MKSMBF$](MKSMBF$)).
* **QB64** has [_CV](_CV) and [_MK$](_MK$) functions which can also deal with extended [Data types](Data-types).
* [INTEGER](INTEGER) values can range from -32768 to 32767.
* Doesn't return [_UNSIGNED](_UNSIGNED) values.

## Example(s)

*Example 1:*

```vb

FIELD #1, 2 AS N$, 12 AS B$...
GET #1     'GET does not need a position or variable with successive FIELD buffer reads
Y = CVI(N$) 

```

> *Explanation:* Reads a field from file #1, and converts the first two bytes (N$) into an integer number assigned to the variable Y.
> Since the representation of an integer number can use up to 5 ASCII characters (five bytes), writing to a file using [MKI$](MKI$) conversion, and then reading back with the [CVI](CVI) conversion can save up to 3 bytes of storage space.

How CVI converts the ASCII code values created by the MKI$ function.

```vb

SCREEN 12
DIM Q AS STRING * 1
Q = CHR$(34)
' create Print using templates to align the values returned 
tmp1$ = "1st character code = ### * 1   =   ### "
tmp2$ = "2nd character code = ### * 256 = ##### "
tmp3$ = "                                 &  "
tmp4$ = "                     CVI Total = ##### "

DO
  COLOR 14: LOCATE 13, 20: INPUT "Enter an Integer from 1 to 32767(0 quits): ", number%
  IF number% < 1 THEN EXIT DO
  CLS
  ASCII$ = MKI$(number%)     ' create the 2 byte character string
  COLOR 11
  _PRINTSTRING (152, 240), "MKI$ creates 2 byte ASCII string: " + Q + ASCII$ + Q ' displays character(s)

  asc1% = ASC(ASCII$)        ' find the ASCII code values of each character
  asc2% = ASC(ASCII$, 2)     ' **QB64** allows ASC to read specific characters in a string
 
  LOCATE 18, 20: PRINT USING tmp1$; asc1%; asc1%
  LOCATE 19, 20: PRINT USING tmp2$; asc2%; asc2% * 256
  LOCATE 20, 20: PRINT USING tmp3$; "-----"
  LOCATE 21, 20: PRINT USING tmp4$; asc1% + (256 * asc2%)
LOOP
SYSTEM 

```

> *Explanation:* All [ASCII](ASCII) characters can be displayed using [_PRINTSTRING](_PRINTSTRING) . The routine gets the [ASCII](ASCII) code, which is the actual value needed by [CVI](CVI). The first byte code is always between 0 and 255. The second byte can return 0 thru 127 and CVI multiplies that value by 256. This proves that you cannot just feed a string number value to [CVI](CVI) and get the result desired. ("90" gets decoded to 12345).

## See Also

* [MKD$](MKD$), [MKI$](MKI$), [MKS$](MKS$), [MKL$](MKL$), [MKDMBF$](MKDMBF$), [MKSMBF$](MKSMBF$)
* [CVS](CVS), [CVD](CVD), [CVL](CVL), [CVSMBF](CVSMBF), [CVDMBF](CVDMBF)
* [_CV](_CV), [_MK$](_MK$)
