The [CVL](CVL) function decodes a 4-byte [STRING](STRING) generated by [MKL$](MKL$) (or read from a file) to [LONG](LONG) numeric values.

## Syntax

> result& = [CVL](CVL)(stringData$)

## Description

* *CV* functions ([CVD](CVD), [CVS](CVS), [CVI](CVI), [CVL](CVL), [CVDMBF](CVDMBF), [CVSMBF](CVSMBF)) are used to convert values encoded by *MK$* functions ([MKD$](MKD$), [MKS$](MKS$), [MKI$](MKI$), [MKL$](MKL$), [MKDMBF$](MKDMBF$), [MKSMBF$](MKSMBF$)).
* **QB64** has [_CV](_CV) and [_MK$](_MK$) functions which can also deal with extended [Data types](Data-types).
* [LONG](LONG) values can range from -2147483648 to 2147483647.
* Doesn't return [_UNSIGNED](_UNSIGNED) values.

## Example(s)

*Example 1: 4 byte [ASCII](ASCII) character strings show how CVL multipliers convert [MKL$](MKL$) values into a 4 byte [LONG](LONG) value.

```vb

PRINT CVL(CHR$(1) + STRING$(3, 0)) 'ASC(CHR$(1)) * 1 = 1
PRINT CVL(CHR$(0) + CHR$(1) + STRING$(2, 0)) 'ASC(CHR$(1)) * 256 = 256
PRINT CVL(STRING$(2, 0) + CHR$(1) + CHR$(0)) 'ASC(CHR$(1)) * 256 * 256 = 65536
PRINT CVL(STRING$(3, 0) + CHR$(1)) 'ASC(CHR$(1)) * 256 * 256 * 256 = 16777216 

```

*Example 2:*

```vb

FIELD #1, 4 AS N$, 12 AS B$...
GET #1
Y& = CVL(N$) 

```

> *Explanation:* Reads a field from file #1, and converts the first four bytes (N$) into a long integer value assigned to the variable Y&.

> Since the representation of a long number can use up to 10 ASCII characters (ten bytes), writing to a file using [MKL$](MKL$) conversion, and then reading back with the [CVL](CVL) conversion can save up to 6 bytes of storage space.

## See Also

* [MKD$](MKD$), [MKI$](MKI$), [MKS$](MKS$), [MKL$](MKL$), [MKDMBF$](MKDMBF$), [MKSMBF$](MKSMBF$)
* [CVI](CVI), [CVS](CVS), [CVD](CVD), [CVDMBF](CVDMBF), [CVSMBF](CVSMBF)
* [_CV](_CV), [_MK$](_MK$)
