|    | .0 | .1 | .2 | .3 | .4 | .5 | .6 | .7 | .8 | .9 | .A | .B | .C | .D | .E | .F |
| -- | -- | -- | -- | -- | -- | -- | -- | -- | -- | -- | -- | -- | -- | -- | -- | -- |
| 0. | NUL 0 | ☺ 263A | ☻ 263B | ♥ 2665 | ♦ 2666 | ♣ 2663 | ♠ 2660 | • 2022 | ◘ 25D8 | ○ 25CB | ◙ 25D9 | ♂ 2642 | ♀ 2640 | ♪ 266A | ♫ 266B | ☼ 263C |
| 1. | ► 25BA | ◄ 25C4 | ↕ 2195 | ‼ 203C | ¶ B6 | § A7 | ▬ 25AC | ↨ 21A8 | ↑ 2191 | ↓ 2193 | → 2192 | ← 2190 | ∟ 221F | ↔ 2194 | ▲ 25B2 | ▼ 25BC |
| 2. |   20 | ! 21 | " 22 | # 23 | $ 24 | % 25 | & 26 | ' 27 | ( 28 | ) 29 | * 2A | + 2B | , 2C | - 2D | . 2E | / 2F |
| 3. | 0 30 | 1 31 | 2 32 | 3 33 | 4 34 | 5 35 | 6 36 | 7 37 | 8 38 | 9 39 | : 3A | ; 3B | < 3C | = 3D | > 3E | ? 3F |
| 4. | @ 40 | A 41 | B 42 | C 43 | D 44 | E 45 | F 46 | G 47 | H 48 | I 49 | J 4A | K 4B | L 4C | M 4D | N 4E | O 4F |
| 5. | P 50 | Q 51 | R 52 | S 53 | T 54 | U 55 | V 56 | W 57 | X 58 | Y 59 | Z 5A | [ 5B | \ 5C | ] 5D | ^ 5E | _ 5F |
| 6. | ` 60 | a 61 | b 62 | c 63 | d 64 | e 65 | f 66 | g 67 | h 68 | i 69 | j 6A | k 6B | l 6C | m 6D | n 6E | o 6F |
| 7. | p 70 | q 71 | r 72 | s 73 | t 74 | u 75 | v 76 | w 77 | x 78 | y 79 | z 7A | { 7B | \| 7C | } 7D | ~ 7E | ⌂ 2302 |
| 8. | Ç C7 | ü FC | é E9 | â E2 | ä E4 | à E0 | å E5 | ç E7 | ê EA | ë EB | è E8 | ï EF | î EE | ì EC | Ä C4 | Å C5 |
| 9. | É C9 | æ E6 | Æ C6 | ô F4 | ö F6 | ò F2 | û FB | ù F9 | ÿ FF | Ö D6 | Ü DC | ¢ A2 | £ A3 | ¥ A5 | ₧ 20A7 | ƒ 192 |
| A. | á E1 | í ED | ó F3 | ú FA | ñ F1 | Ñ D1 | ª AA | º BA | ¿ BF | ⌐ 2310 | ¬AC | ½BD | ¼ BC | ¡ A1 | « AB | » BB |
| B. | ░ 2591 | ▒ 2592 | ▓ 2593 | │ 2502 | ┤ 2524 | ╡ 2561 | ╢ 2562 | ╖ 2556 | ╕ 2555 | ╣ 2563 | ║ 2551 | ╗ 2557 | ╝ 255D | ╜ 255C | ╛ 255B | ┐ 2510 |
| C. | └ 2514 | ┴ 2534 | ┬ 252C | ├ 251C | ─ 2500 | ┼ 253C | ╞ 255E | ╟ 255F | ╚ 255A | ╔ 2554 | ╩ 2569 | ╦ 2566 | ╠ 2560 | ═ 2550 | ╬ 256C | ╧ 2567 |
| D. | ╨ 2568 | ╤ 2564 | ╥ 2565 | ╙ 2559 | ╘ 2558 | ╒ 2552 | ╓ 2553 | ╫ 256B | ╪ 256A | ┘ 2518 | ┌ 250C | █ 2588 | ▄ 2584 | ▌258C | ▐ 2590 | ▀ 2580 |
| E. | α 3B1 | ß DF | Γ 393 | π 3C0 | Σ 3A3 | σ 3C3 | µB5 | τ3C4 | Φ3A6 | Θ398 | Ω3A9 | δ3B4 | ∞221E | φ3C6 | ε3B5 | ∩2229 |
| F. | ≡ 2261 | ± B1 | ≥ 2265 | ≤ 2264 | ⌠ 2320 | ⌡ 2321 | ÷ F7 | ≈ 2248 | ° B0 | ∙ 2219 | · B7 | √ 221A | ⁿ 207F | ² B2 | ■ 25A0 | A0 |

**CP437** is the character set of the original IBM PC. It is also known as DOS-US, OEM-US or IBM Extended character set. They also may erroneously be referred to as the OEM font, Extended ASCII or High ASCII.

[Code Page 437](http://en.wikipedia.org/wiki/Code_page_437)

* Unicode references:
> * 1) What is the glyph represented by that UNICODE value: [Unicode Format Info](http://www.fileformat.info/info/unicode/char/search.htm)
> * 2) Which fonts support the characters I want to use: [Unicode Fonts](http://en.wikipedia.org/wiki/Unicode_typefaces#Comparison_of_fonts)
> * 3) What was the format again?: [Unicode Formats](http://www.birds-eye.net/definition/u/unicode.shtml)
> * A UTF32 value is usually(but by no means always!) the same as a UTF16 value just with the top 2 bytes set to 0.
* Setting up a typing language in the QB64 IDE:
> Step 1: In the OPTIONS menu select DISPLAY, then check the CUSTOM FONT check-box.
> Step 2: In the OPTIONS menu select LANGUAGE, then select a Code Page (CP850 for example) and click OK.
* Font **cyberbit.ttf**, included with QB64 as of **V0.92**(October 2010), is required to facilitate the **IME**(in Chinese settings) only. The 12.7 MB font is free for **non-commercial** use and is not loaded unless the user switches to the **Input Mode Editor**.
[Setting up the Unicode Input Method Editor in Windows](http://www.fileformat.info/tip/microsoft/enter_unicode.htm)
If you need help with IME support in **Vista** see the following article: [Setting up IME in Vista](http://blogs.msdn.com/b/michkap/archive/2006/07/20/671835.aspx)
> QB64 can use several Windows fonts when 'cyberbit' is not present so it is not necessary to include with program packages. 

## Example(s)

Setting up Unicode functionality in a program using any monospace font containing characters from a Code Page.

```vb

_FONT _LOADFONT("c:\windows\fonts\cour.ttf", 24, "MONOSPACE")
'use codepage 850
RESTORE CP850
FOR ascii_code& = 0 TO 255
    READ unicode_code&
    _MAPUNICODE unicode_code& TO ascii_code&
NEXT
                                             
FOR x = 128 TO 255   
    PRINT CHR$(x);                'demo: display the upper character map
NEXT

PRINT: PRINT
INPUT "Type some characters now >", Alt_numpad$ 'input some characters with Alt + number pad
PRINT
PRINT Alt_numpad$

CP850: 
DATA 0,9786,9787,9829,9830,9827,9824,8226,9688,9675,9689,9794,9792,9834,9835,9788,9658,9668
DATA 8597,8252,182,167,9644,8616,8593,8595,8594,8592,8735,8596,9650,9660,32,33,34,35,36,37
DATA 38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66
DATA 67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95
DATA 96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,
DATA 118,119,120,121,122,123,124,125,126,8962,199,252,233,226,228,224,229,231,234,235,232
DATA 239,238,236,196,197,201,230,198,244,246,242,251,249,255,214,220,248,163,216,215,402,225
DATA 237,243,250,241,209,170,186,191,174,172,189,188,161,171,187,9617,9618,9619,9474,9508
DATA 193,194,192,169,9571,9553,9559,9565,162,165,9488,9492,9524,9516,9500,9472,9532,227,195
DATA 9562,9556,9577,9574,9568,9552,9580,164,240,208,202,203,200,305,205,206,207,9496,9484
DATA 9608,9604,166,204,9600,211,223,212,210,245,213,181,254,222,218,219,217,253,221,175,180
DATA 173,177,8215,190,182,167,247,184,176,168,183,185,179,178,9632,160 

```

[Western European Unicode CP850](http://en.wikipedia.org/wiki/Code_page_850) .......... [Western European(euro) CP858](http://en.wikipedia.org/wiki/CP858)

[Hebrew Unicode CP862(80–9A hex)](http://en.wikipedia.org/wiki/Code_page_862)

## See Also
 
* [ASCII](ASCII), [ASCII](ASCII)
* [_KEYHIT](_KEYHIT), [_KEYDOWN](_KEYDOWN)
* [_MAPUNICODE](_MAPUNICODE) (Unicode TO ASCII code statement)
* [Code Pages](Code-Pages) (Various Languages)
* [Text Using Graphics](Text-Using-Graphics)
