The [_CV](_CV) function is used to convert [_MK$](_MK$), [ASCII](ASCII), [STRING](STRING) values to numerical values.

## Syntax

> result = [_CV](_CV)(numericalType, MKstringValue$)

## Parameter(s)

* numericalType is any number type: [INTEGER](INTEGER), [LONG](LONG), [SINGLE](SINGLE), [DOUBLE](DOUBLE), [_INTEGER64](_INTEGER64), [_FLOAT](_FLOAT), [_BYTE](_BYTE) or [_OFFSET](_OFFSET).
* Integer, Long, Byte and Bit values can be signed or [_UNSIGNED](_UNSIGNED).
* The MKstringvalue$ parameter must be a string value generated by [_MK$](_MK$)

## Description

* The MKstringvalue$ value type must match the numerical type parameter used. 
* [_MK$](_MK$) [STRING](STRING) values consist of [ASCII](ASCII) characters in the same byte length as the number value type.

## Example(s)

Using the _MK$ and _CV functions:

```vb

DIM i64 AS _INTEGER64
DIM i64str AS STRING

i64 = 2 ^ 61
i64str = _MK$(_INTEGER64, i64)

PRINT "I64:"; i64
PRINT "_MK$: "; i64str

i64 = _CV(_INTEGER64, i64str)
PRINT "_CV:"; i64 

```

```text

I64: 2305843009213693952
_MK$:
_CV: 2305843009213693952

```

> The _MK$ string result may not print anything to the screen, as in the example above, unless [_CONTROLCHR](_CONTROLCHR) is set to OFF.

## See Also

* [_MK$](_MK$) (QB64 string conversion function)
* [MKI$](MKI$), [CVI](CVI), [INTEGER](INTEGER)
* [MKL$](MKL$), [CVL](CVL), [LONG](LONG)
* [MKS$](MKS$), [CVS](CVS), [SINGLE](SINGLE)
* [MKD$](MKD$), [CVD](CVD), [DOUBLE](DOUBLE)
* [MKSMBF$](MKSMBF$), [CVSMBF](CVSMBF) (Microsoft Binary Format)
* [MKDMBF$](MKDMBF$), [CVDMBF](CVDMBF) (Microsoft Binary Format)
* [PDS (7.1) Procedures](PDS-(7.1)-Procedures)
* [_CONTROLCHR](_CONTROLCHR)
