The [_KEYHIT](_KEYHIT) function returns [ASCII](ASCII) one and two byte, OpenGL Virtual Key and Unicode keyboard key press codes.

## Syntax

> keycode& = [_KEYHIT](_KEYHIT)

## Description

* Return values range up to &H40000000 so use a [LONG](LONG) or [_INTEGER64](_INTEGER64) variable type. See the [_KEYDOWN](_KEYDOWN) code list:
  * 0-255: [ASCII](ASCII) values (Refer to [CP437](http://en.wikipedia.org/wiki/Code_page_437)).
  * 256-65535: [ASCII](ASCII) character codes : code = [CVI](CVI)([CHR$](CHR$)(0) + [CHR$](CHR$)(scancode)) (unaffected by SHIFT/ALT/CTRL modifiers).
  * 65536-&H40000000: [_KEYDOWN](_KEYDOWN) (designated with + for 100000 on keyboard below)
  * **Negative** [LONG](LONG) values returned indicate that a key was released or a lock function key has been turned off.
* **Note: _KEYHIT can only return one value at a time so use the [_KEYDOWN](_KEYDOWN) keyhit value to find key combinations.**
* To receive input from a [$CONSOLE]($CONSOLE) window, use [_CINP](_CINP).

```text

'                                **_KEYHIT Keyboard Codes**
'
' **Esc  F1    F2    F3    F4    F5    F6    F7    F8    F9    F10   F11   F12   Sys  ScL Pause**
'  27 15104 15360 15616 15872 16128 16384 16640 16896 17152 17408 34048 34304 +316 +302 +019
' **`~  1!  2@  3#  4$  5%  6^  7&  8*  9(  0) -_ =+ BkSp   Ins   Hme   PUp   NumL   /     *    -**
' 126 33  64  35  36  37  94  38  42  40  41 95 43   8   20992 18176 18688 +300   47    42   45
' * 96 49  50  51  52  53  54  55  56  57  48 45 61*
' **Tab Q   W   E   R   T   Y   U   I   O   P  [{  ]}  \|   Del   End   PDn   7Hme  8/▲   9PU   + **
'  9  81  87  69  82  84  89  85  73  79  80 123 125 124 21248 20224 20736 18176 18432 18688 43
' *   113 119 101 114 116 121 117 105 111 112  91  93  92                    55    56    57 *
' **CapL   A   S   D   F   G   H   J   K   L   ;:  '" Enter                   4/◄-   5    6/-►
' +301  65  83  68  70  71  72  74  75  76  58  34  13                     19200 19456 19712  **E**
' *      97 115 100 102 103 104 106 107 108  59  39                          52    53    54 *   **n**
' **Shift   Z   X   C   V   B   N   M   ,<  .>  /?    Shift       ▲           1End  2/▼   3PD   t**
' +304   90  88  67  86  66  78  77  60  62  63    +303       18432        20224 20480 20736  **e**
' *      122 120  99 118  98 110 109  44  46  47                             49    50    51 *   **r**
' **Ctrl   Win  Alt     Spacebar      Alt  Win  Menu  Ctrl   ◄-   ▼   -►      0Ins        .Del **
' +306  +311 +308       32         +307 +312 +319  +305 19200 20480 19712  20992       21248 13
'                                                                      *     48          46*
'
'     **    Lower value = LCase/NumLock On __________________ + = add 100000 **

```
 
> >= &H40000000: [Unicode](Unicode).

* Font **cyberbit.ttf**, included with QB64 (**version 0.92 and up**), is required to facilitate the **IME**(in Chinese settings) only. The 12.7 MB font is free for **non-commercial** use and is not loaded unless the user switches to the **Input Mode Editor**. Set to "UNICODE".
**[Setting up the Unicode Input Method Editor in Windows](http://www.fileformat.info/tip/microsoft/enter_unicode.htm)**
If you need help with IME support in **Vista** see the following article: [Setting up IME in Vista](http://blogs.msdn.com/b/michkap/archive/2006/07/20/671835.aspx)
* QB64 can use several Windows fonts when **cyberbit** is not present so it is not necessary to include with program packages. 
* An **important difference** between [INKEY$](INKEY$) and _KEYHIT is how they work when **CTRL, ALT** or **SHIFT** are used. INKEY$ returns a different code if you hold down CTRL, ALT or SHIFT before pressing  F1 (for example). _KEYHIT will return the same code regardless of which modifiers were used but you can check [_KEYDOWN](_KEYDOWN) to see which modifying keys are being used.
* **Keyboards with an Alt Gr key note:** _KEYHIT may return both Alt (100307) and Ctrl (100306) codes when AltGr key is pressed or released.

## Example(s)

This routine will return the codes for any keyboard presses.

```vb

DEFLNG A-Z
SCREEN _NEWIMAGE(800, 600, 8)
CLS , 1
font = _LOADFONT("cyberbit.ttf", 24)
unifont = _LOADFONT("cyberbit.ttf", 24, "UNICODE")
_FONT font

DO
  x = _KEYHIT
  IF x THEN
    IF x < 0 THEN  'negative value means key released
      COLOR 2
      PRINT "Released ";
      x = -x
    ELSE
      COLOR 10
      PRINT "Pressed ";   'positive value means key pressed
    END IF
    IF x < 256 THEN    'ASCII code values
      PRINT "ASCII "; x;
      IF x >= 32 AND x <= 255 THEN PRINT "[" + CHR$(x) + "]" ELSE PRINT
    END IF
    IF x >= 256 AND x < 65536 THEN '2 byte key codes
      PRINT "2-BYTE-COMBO "; x AND 255; x \ 256;
      x2 = x \ 256
      IF x2 >= 32 AND x2 <= 255 THEN PRINT "[" + CHR$(x2) + "]" ELSE PRINT
    END IF
    IF x >= 100000 AND x < 200000 THEN      'QB84 Virtual Key codes
      PRINT "SDL VK"; x - 100000
      END IF
      IF x >= 200000 AND x < &H40000000 THEN
            PRINT "QB64 VK"; x - 200000
    END IF
    IF x >= &H40000000 THEN              'Unicode values (IME Input mode)
      PRINT "UNICODE "; x - &H40000000; "0x" + HEX$(x - &H40000000) + " ...";
      cx = POS(1): cy = CSRLIN
      _FONT unifont
      LOCATE cy, cx
      COLOR 15
      z$ = MKL$(x - &H40000000) + MKL$(0)
      PRINT z$ + z$ + z$;
      _FONT font
      LOCATE cy, 1: PRINT
    END IF
  END IF
LOOP

```

## See Also

* [_KEYDOWN](_KEYDOWN), [_CINP](_CINP)
* [_MAPUNICODE](_MAPUNICODE), [_MAPUNICODE (function)](_MAPUNICODE-(function)) 
* [INKEY$](INKEY$), [ASCII](ASCII) (code table), 
* [Unicode](Unicode), [Code Pages](Code-Pages) (by region)
* [INP](INP)([&H](&H)), [Scancodes](Scancodes)
* [ON KEY(n)](ON-KEY(n)), [KEY(n)](KEY(n)), [KEY n](KEY-n)
* [Windows Libraries](Windows-Libraries)
