**_glGetString:** return a string describing the current GL connection


## Syntax


  FUNCTION _glGetString&& (BYVAL name AS _UNSIGNED LONG)
  const GLubyte* **_glGetString**(GLenum name);

  const GLubyte* **_glGetStringi**(GLenum name, GLuint index);

; name
>  Specifies a symbolic constant, one of [_GL_VENDOR](_GL_VENDOR), [_GL_RENDERER](_GL_RENDERER), [_GL_VERSION](_GL_VERSION), or [_GL_SHADING_LANGUAGE_VERSION](_GL_SHADING_LANGUAGE_VERSION). Additionally, **_glGetStringi** accepts the [_GL_EXTENSIONS](_GL_EXTENSIONS) token.
; index
>  For **_glGetStringi**, specifies the index of the string to return.


## Description


**_glGetString** returns a pointer to a static string describing some aspect of the current GL connection. name can be one of the following:

; [_GL_VENDOR](_GL_VENDOR)
>  
Returns the company responsible for this GL implementation. This name does not change from release to release.
; [_GL_RENDERER](_GL_RENDERER)
>  
Returns the name of the renderer. This name is typically specific to a particular configuration of a hardware platform. It does not change from release to release.
; [_GL_VERSION](_GL_VERSION)
>  
Returns a version or release number.
; [_GL_SHADING_LANGUAGE_VERSION](_GL_SHADING_LANGUAGE_VERSION)
>  
Returns a version or release number for the shading language.

Strings [_GL_VENDOR](_GL_VENDOR) and [_GL_RENDERER](_GL_RENDERER) together uniquely specify a platform. They do not change from release to release and should be used by platform-recognition algorithms.

**_glGetStringi** returns a pointer to a static string indexed by index. name can be one of the following:

; [_GL_EXTENSIONS](_GL_EXTENSIONS)
>  For **_glGetStringi** only, returns the extension string supported by the implementation at index. The index index is on the range [0 to [_glGet](_glGet) - 1].
; [_GL_SHADING_LANGUAGE_VERSION](_GL_SHADING_LANGUAGE_VERSION)
>  Returns one of the versions of [GLSL](GLSL) supported by this implementation. index is on the range [0 to [_glGet](_glGet) - 1].

The [_GL_VERSION](_GL_VERSION) and [_GL_SHADING_LANGUAGE_VERSION](_GL_SHADING_LANGUAGE_VERSION) strings begin with a version number. The version number uses one of these forms:

*major_number.minor_number*

or

*major_number.minor_number.release_number*

Vendor-specific information may follow the version number. Its format depends on the implementation, but a space always separates the version number and the vendor-specific information.

All strings are null-terminated.


## Notes


If an error is generated, **_glGetString** returns 0.

The client and server may support different versions. **_glGetString** always returns a compatible version number. The release number always describes the server.


## Error(s)


[_GL_INVALID_ENUM](_GL_INVALID_ENUM) is generated if name is not an accepted value.

[_GL_INVALID_VALUE](_GL_INVALID_VALUE) is generated by **_glGetStringi** if index is outside the valid range for indexed state name.




Copyright 1991-2006 Silicon Graphics, Inc. Copyright 2010 Khronos Group. This document is licensed under the SGI Free Software B License. For details, see [http://oss.sgi.com/projects/FreeB/ http://oss.sgi.com/projects/FreeB/].

