**_glIsEnabled, glIsEnabledi:** test whether a capability is enabled


## Syntax


  FUNCTION _glIsEnabled~%% (BYVAL cap AS _UNSIGNED LONG)
  GLboolean **_glIsEnabled**(GLenum cap);

  GLboolean **_glIsEnabledi**(GLenum cap, GLuint index);

; cap
>  Specifies a symbolic constant indicating a GL capability.
; index
>  Specifies the index of the capability.


## Description


**_glIsEnabled** returns [_GL_TRUE](_GL_TRUE) if cap is an enabled capability and returns [_GL_FALSE](_GL_FALSE) otherwise. Boolean states that are indexed may be tested with **_glIsEnabledi**. For **_glIsEnabledi**, index specifies the index of the capability to test. index must be between zero and the count of indexed capabilities for cap. Initially all capabilities except [_GL_DITHER](_GL_DITHER) are disabled; [_GL_DITHER](_GL_DITHER) is initially enabled.

The following capabilities are accepted for cap:



{|
|+
! **Constant**
! **See**
|+
| [_GL_BLEND](_GL_BLEND)
| [_glBlendFunc](_glBlendFunc), [_glLogicOp](_glLogicOp)
|+
| [_GL_CLIP_DISTANCE](_GL_CLIP_DISTANCE)*i*
| [_glEnable](_glEnable)
|+
| [_GL_COLOR_LOGIC_OP](_GL_COLOR_LOGIC_OP)
| [_glLogicOp](_glLogicOp)
|+
| [_GL_CULL_FACE](_GL_CULL_FACE)
| [_glCullFace](_glCullFace)
|+
| [_GL_DEPTH_CLAMP](_GL_DEPTH_CLAMP)
| [_glEnable](_glEnable)
|+
| [_GL_DEBUG_OUTPUT](_GL_DEBUG_OUTPUT)
| [_glEnable](_glEnable)
|+
| [_GL_DEBUG_OUTPUT_SYNCHRONOUS](_GL_DEBUG_OUTPUT_SYNCHRONOUS)
| [_glEnable](_glEnable)
|+
| [_GL_DEPTH_TEST](_GL_DEPTH_TEST)
| [_glDepthFunc](_glDepthFunc), [_glDepthRange](_glDepthRange)
|+
| [_GL_DITHER](_GL_DITHER)
| [_glEnable](_glEnable)
|+
| [_GL_FRAMEBUFFER_SRGB](_GL_FRAMEBUFFER_SRGB)
| [_glEnable](_glEnable)
|+
| [_GL_LINE_SMOOTH](_GL_LINE_SMOOTH)
| [_glLineWidth](_glLineWidth)
|+
| [_GL_MULTISAMPLE](_GL_MULTISAMPLE)
| [_glSampleCoverage](_glSampleCoverage)
|+
| [_GL_POLYGON_SMOOTH](_GL_POLYGON_SMOOTH)
| [_glPolygonMode](_glPolygonMode)
|+
| [_GL_POLYGON_OFFSET_FILL](_GL_POLYGON_OFFSET_FILL)
| [_glPolygonOffset](_glPolygonOffset)
|+
| [_GL_POLYGON_OFFSET_LINE](_GL_POLYGON_OFFSET_LINE)
| [_glPolygonOffset](_glPolygonOffset)
|+
| [_GL_POLYGON_OFFSET_POINT](_GL_POLYGON_OFFSET_POINT)
| [_glPolygonOffset](_glPolygonOffset)
|+
| [_GL_PROGRAM_POINT_SIZE](_GL_PROGRAM_POINT_SIZE)
| [_glEnable](_glEnable)
|+
| [_GL_PRIMITIVE_RESTART](_GL_PRIMITIVE_RESTART)
| [_glEnable](_glEnable), [_glPrimitiveRestartIndex](_glPrimitiveRestartIndex)
|+
| [_GL_SAMPLE_ALPHA_TO_COVERAGE](_GL_SAMPLE_ALPHA_TO_COVERAGE)
| [_glSampleCoverage](_glSampleCoverage)
|+
| [_GL_SAMPLE_ALPHA_TO_ONE](_GL_SAMPLE_ALPHA_TO_ONE)
| [_glSampleCoverage](_glSampleCoverage)
|+
| [_GL_SAMPLE_COVERAGE](_GL_SAMPLE_COVERAGE)
| [_glSampleCoverage](_glSampleCoverage)
|+
| [_GL_SAMPLE_MASK](_GL_SAMPLE_MASK)
| [_glEnable](_glEnable)
|+
| [_GL_SCISSOR_TEST](_GL_SCISSOR_TEST)
| [_glScissor](_glScissor)
|+
| [_GL_STENCIL_TEST](_GL_STENCIL_TEST)
| [_glStencilFunc](_glStencilFunc), [_glStencilOp](_glStencilOp)
|+
| [_GL_TEXTURE_CUBEMAP_SEAMLESS](_GL_TEXTURE_CUBEMAP_SEAMLESS)
| [_glEnable](_glEnable)
|}




## Notes


If an error is generated, **_glIsEnabled** and **_glIsEnabledi** return [_GL_FALSE](_GL_FALSE).

[_GL_DEBUG_OUTPUT](_GL_DEBUG_OUTPUT) and [_GL_DEBUG_OUTPUT_SYNCHRONOUS](_GL_DEBUG_OUTPUT_SYNCHRONOUS) are available only if the GL version is 4.3 or greater.


## Error(s)


[_GL_INVALID_ENUM](_GL_INVALID_ENUM) is generated if cap is not an accepted value.

[_GL_INVALID_VALUE](_GL_INVALID_VALUE) is generated by **_glIsEnabledi** if index is outside the valid range for the indexed state cap.


## See Also


[_GL](_GL)
[_glEnable](_glEnable), [_glDisable](_glDisable), [_glGet](_glGet)




Copyright 1991-2006 Silicon Graphics, Inc. Copyright 2010-2011 Khronos Group. This document is licensed under the SGI Free Software B License. For details, see [http://oss.sgi.com/projects/FreeB/ http://oss.sgi.com/projects/FreeB/].

